var Controls = {
	menuItems: [ { desc: "Accept:",
				key:  "ACCEPT",
				val:  Keys.ACCEPT },
			   { desc: "Cancel/Skip:",
				key:  "CANCEL",
				val:  Keys.CANCEL },
			   { desc: "Move Left:",
				key:  "LEFT",
				val:  Keys.LEFT },
			   { desc: "Move Right:",
				key:  "RIGHT",
				val:  Keys.RIGHT },
			   { desc: "Move Down:",
				key:  "DOWN",
				val:  Keys.DOWN },
			   { desc: "Rotate Left:",
				key:  "ROTATELEFT",
				val:  Keys.ROTATELEFT },
			   { desc: "Rotate Right:",
				key:  "ROTATERIGHT",
				val:  Keys.ROTATERIGHT },
			   { desc: "Block Fall:",
				key:  "FALL",
				val:  Keys.FALL },
			   { desc: "Pause Game:",
				key:  "PAUSE",
				val:  Keys.PAUSE } ],
	currentSelection: 0,
	drawItem: function(index, color) {
		if(!color)
			FONT.setColorMask(WHITE);
		else FONT.setColorMask(color);
		
		DrawText(30, 30 + index * 14, this.menuItems[index].desc);
		
		var key = this.menuItems[index].val;
		var keyStr = "";
		if(key == KEY_LEFT) {
			keyStr = "Left Arrow";
		} else if(key == KEY_RIGHT) {
			keyStr = "Right Arrow";
		} else if(key == KEY_DOWN) {
			keyStr = "Down Arrow";
		} else if(key == KEY_UP) {
			keyStr = "Up Arrow";
		} else if(key == KEY_CTRL) {
			keyStr = "Ctrl";
		} else if(key == KEY_SPACE) {
			keyStr = "Space";
		} else if(key == KEY_ALT) {
			keyStr = "Alt";
		} else if(key == KEY_ESCAPE) {
			keyStr = "Escape";
		} else if(key == KEY_ENTER) {
			keyStr = "Enter";
		} else {
			keyStr = GetKeyString(key, true);
		}
		DrawText(180, 30 + index * 14, keyStr);
	},
	img: undefined,
	run: function() {
		var isPressed = false;
		
		for(var i in this.menuItems) {
			this.menuItems[i].val = Keys[this.menuItems[i].key];
		}
		
		BACKGROUND.blit(0, 0);
		WINDOW.drawWindow(20, 20, SCREENWIDTH - 40, SCREENHEIGHT - 40);
		this.img = GrabImage(0, 0, SCREENWIDTH, SCREENHEIGHT);
		
		while(true) {
			if(isPressed) {
				if(!IsKeyPressed(KEY_DOWN) && !IsKeyPressed(KEY_UP) && !IsKeyPressed(Keys.ACCEPT))
					isPressed = false;
			} else if(IsKeyPressed(KEY_DOWN) && !isPressed) {
				this.currentSelection = (this.currentSelection + 1) % (this.menuItems.length + 2);
				isPressed = true;
			} else if(IsKeyPressed(KEY_UP) && !isPressed) {
				this.currentSelection = (this.currentSelection == 0) ? this.menuItems.length + 1 : this.currentSelection - 1;
				isPressed = true;
			} else if(IsKeyPressed(Keys.ACCEPT) && !isPressed) {
				// select selection...
				// if selected Save, save everything.
				if(this.currentSelection == this.menuItems.length) {
					for(var i = 0; i < this.menuItems.length; i++) {
						Keys[this.menuItems[i].key] = this.menuItems[i].val;
					}
					// save controls
					var file = OpenFile("Controls.sav");
					for(var key in Keys) {
						file.write(key, Keys[key]);
					}
					file.flush();
				}
				// if selected Back, go back.
				else if(this.currentSelection == this.menuItems.length + 1) {
					return;
				} else { // selected some key
					EatKey();
					this.blit();
					WINDOW.drawWindow(70, 95, 180, 25);
					DrawText(78, 102, "Please enter a new, unused key.");
					FlipScreen();
					// you really don't want two keys that do the same thing!
					var min = (this.currentSelection > 1) ? 2 : 0;
					var max = (this.currentSelection > 1) ? 8 : 1;
					var key;
					do {
						key = GetKey();
					} while(this.hasKeyBinded(key, min, max));
					this.menuItems[this.currentSelection].val = key;
					EatKey();
				}
			}
			// for drawing
			this.blit();
			FlipScreen();
		}
	},
	hasKeyBinded: function(key, min, max) {
		for(var i=min;i<=max;i++) {
			if(this.menuItems[i].val == key)
				return true;
		}
		return false;
	},
	blit: function() {
		this.img.blit(0, 0);
		
		var i = 0;
		for(i = 0; i < this.menuItems.length; i++) {
			if(i == this.currentSelection) {
				this.drawItem(i, GOLD);
				ARROWMENU.blit(22, 30 + i * 14);
			} else this.drawItem(i);
		}
		FONT.setColorMask(WHITE);
		if(i == this.currentSelection) {
			FONT.setColorMask(GOLD);
			ARROWMENU.blit(22, 35 + i * 14);
		}
		DrawText(30, 35 + i * 14, "Save");
		FONT.setColorMask(WHITE);
		if(i + 1 == this.currentSelection) {
			FONT.setColorMask(GOLD);
			ARROWMENU.blit(22, 49 + i * 14);
		}
		DrawText(30, 49 + i * 14, "Back");
	}
};